/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperclip;

import io.papermc.paperclip.Agent;
import io.papermc.paperclip.PatchData;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.apache.commons.compress.compressors.CompressorException;
import org.jbsdiff.InvalidHeaderException;
import org.jbsdiff.Patch;

public final class Paperclip {
    public static void main(String[] args) {
        Path paperJar = Paperclip.setupEnv();
        String main = Paperclip.getMainClass(paperJar);
        Method mainMethod = Paperclip.getMainMethod(paperJar, main);
        try {
            mainMethod.invoke(null, new Object[]{args});
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            System.err.println("Error while running patched jar");
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static Path setupEnv() {
        PatchData patchData;
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            System.err.println("Could not create hashing instance");
            e.printStackTrace();
            System.exit(1);
            throw new InternalError();
        }
        try (InputStream defaultsInput = Paperclip.class.getResourceAsStream("/patch.properties");
             BufferedReader defaultsReader = new BufferedReader(new InputStreamReader(defaultsInput));
             Reader optionalReader = Paperclip.getConfig();){
            patchData = PatchData.parse(defaultsReader, optionalReader);
        }
        catch (IOException | IllegalArgumentException e) {
            if (e instanceof IOException) {
                System.err.println("Error reading patch file");
            } else {
                System.err.println("Invalid patch file");
            }
            e.printStackTrace();
            System.exit(1);
            throw new InternalError();
        }
        Path paperJar = Paperclip.checkPaperJar(digest, patchData);
        if (Boolean.getBoolean("paperclip.patchonly")) {
            System.exit(0);
        }
        return paperJar;
    }

    private static Path checkPaperJar(MessageDigest digest, PatchData patchData) {
        byte[] patch;
        byte[] vanillaJarBytes;
        Path cache = Paths.get("cache", new String[0]);
        Path paperJar = cache.resolve("patched_" + patchData.version + ".jar");
        if (!Paperclip.isJarInvalid(digest, paperJar, patchData.patchedHash)) {
            return paperJar;
        }
        Path vanillaJar = Paperclip.checkVanillaJar(digest, patchData, cache);
        if (Files.exists(paperJar, new LinkOption[0])) {
            try {
                Files.delete(paperJar);
            }
            catch (IOException e) {
                System.err.println("Failed to delete invalid jar " + paperJar.toAbsolutePath());
                e.printStackTrace();
                System.exit(1);
            }
        }
        System.out.println("Patching vanilla jar...");
        try {
            vanillaJarBytes = Paperclip.readBytes(vanillaJar);
            patch = Paperclip.readFully(patchData.patchFile.openStream());
        }
        catch (IOException e) {
            System.err.println("Failed to read vanilla jar and patch file");
            e.printStackTrace();
            System.exit(1);
            throw new InternalError();
        }
        try (BufferedOutputStream jarOutput = new BufferedOutputStream(Files.newOutputStream(paperJar, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING));){
            Patch.patch(vanillaJarBytes, patch, jarOutput);
        }
        catch (IOException | CompressorException | InvalidHeaderException e) {
            System.err.println("Failed to patch vanilla jar");
            e.printStackTrace();
            System.exit(1);
        }
        if (Paperclip.isJarInvalid(digest, paperJar, patchData.patchedHash)) {
            System.err.println("Failed to patch vanilla jar, output patched jar is still not valid");
            System.exit(1);
        }
        return paperJar;
    }

    private static Path checkVanillaJar(MessageDigest digest, PatchData patchData, Path cache) {
        Path vanillaJar = cache.resolve("mojang_" + patchData.version + ".jar");
        if (!Paperclip.isJarInvalid(digest, vanillaJar, patchData.originalHash)) {
            return vanillaJar;
        }
        System.out.println("Downloading vanilla jar...");
        try {
            if (!Files.isDirectory(cache, new LinkOption[0])) {
                Files.createDirectories(cache, new FileAttribute[0]);
            }
            Files.deleteIfExists(vanillaJar);
        }
        catch (IOException e) {
            System.err.println("Failed to setup cache directory");
            e.printStackTrace();
            System.exit(1);
        }
        try (ReadableByteChannel source = Channels.newChannel(patchData.originalUrl.openStream());
             FileChannel fileChannel = FileChannel.open(vanillaJar, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
            fileChannel.transferFrom(source, 0L, Long.MAX_VALUE);
        }
        catch (IOException e) {
            System.err.println("Failed to download vanilla jar");
            e.printStackTrace();
            System.exit(1);
        }
        if (Paperclip.isJarInvalid(digest, vanillaJar, patchData.originalHash)) {
            System.err.println("Downloaded vanilla jar is not valid");
            System.exit(1);
        }
        return vanillaJar;
    }

    /*
     * Exception decompiling
     */
    private static String getMainClass(Path paperJar) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Method getMainMethod(Path paperJar, String mainClass) {
        Agent.addToClassPath(paperJar);
        try {
            Class<?> cls = Class.forName(mainClass, true, ClassLoader.getSystemClassLoader());
            return cls.getMethod("main", String[].class);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            System.err.println("Failed to find main method in patched jar");
            e.printStackTrace();
            System.exit(1);
            throw new InternalError();
        }
    }

    private static Reader getConfig() throws IOException {
        Path customPatchInfo = Paths.get("paperclip.properties", new String[0]);
        if (Files.exists(customPatchInfo, new LinkOption[0])) {
            return Files.newBufferedReader(customPatchInfo);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readFully(InputStream in) throws IOException {
        try {
            int read;
            byte[] buffer = new byte[16384];
            int off = 0;
            while ((read = in.read(buffer, off, buffer.length - off)) != -1) {
                if ((off += read) != buffer.length) continue;
                buffer = Arrays.copyOf(buffer, buffer.length * 2);
            }
            byte[] byArray = Arrays.copyOfRange(buffer, 0, off);
            return byArray;
        }
        finally {
            in.close();
        }
    }

    private static byte[] readBytes(Path file) {
        try {
            return Paperclip.readFully(Files.newInputStream(file, new OpenOption[0]));
        }
        catch (IOException e) {
            System.err.println("Failed to read all of the data from " + file.toAbsolutePath());
            e.printStackTrace();
            System.exit(1);
            throw new InternalError();
        }
    }

    private static boolean isJarInvalid(MessageDigest digest, Path jar, byte[] hash) {
        if (Files.exists(jar, new LinkOption[0])) {
            byte[] jarBytes = Paperclip.readBytes(jar);
            return !Arrays.equals(hash, digest.digest(jarBytes));
        }
        return true;
    }
}

