/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperclip;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;

record PatchData(URL patchFile, URL originalUrl, byte[] originalHash, byte[] patchedHash, String version) {
    private static PatchData create(Properties prop) {
        URL originalUrl;
        String patch = prop.getProperty("patch");
        URL patchFile = PatchData.class.getResource("/" + patch);
        File tempFile = new File(patch);
        if (tempFile.exists()) {
            try {
                patchFile = tempFile.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (patchFile == null) {
            throw new IllegalArgumentException("Couldn't find " + patch);
        }
        try {
            originalUrl = new URL(prop.getProperty("sourceUrl"));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid URL", e);
        }
        return new PatchData(patchFile, originalUrl, PatchData.fromHex(prop.getProperty("originalHash")), PatchData.fromHex(prop.getProperty("patchedHash")), prop.getProperty("version"));
    }

    static PatchData parse(Reader defaults, Reader optional) throws IOException {
        try {
            Properties defaultProps = new Properties();
            defaultProps.load(defaults);
            Properties props = new Properties(defaultProps);
            if (optional != null) {
                props.load(optional);
            }
            return PatchData.create(props);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid properties file", e);
        }
    }

    private static byte[] fromHex(String s) {
        if (s.length() % 2 != 0) {
            throw new IllegalArgumentException("Hex " + s + " must be divisible by two");
        }
        byte[] bytes = new byte[s.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            byte b;
            char left = s.charAt(i * 2);
            char right = s.charAt(i * 2 + 1);
            bytes[i] = b = (byte)(PatchData.getValue(left) << 4 | PatchData.getValue(right) & 0xF);
        }
        return bytes;
    }

    private static int getValue(char c) {
        int i = Character.digit(c, 16);
        if (i < 0) {
            throw new IllegalArgumentException("Invalid hex char: " + c);
        }
        return i;
    }
}

