/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperclip;

import io.papermc.paperclip.DownloadContext;
import io.papermc.paperclip.FileEntry;
import io.papermc.paperclip.PatchEntry;
import io.papermc.paperclip.Util;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public final class Paperclip {
    public static void main(String[] args) {
        if (Path.of("", new String[0]).toAbsolutePath().toString().contains("!")) {
            System.err.println("Paperclip may not run in a directory containing '!'. Please rename the affected folder.");
            System.exit(1);
        }
        URL[] classpathUrls = Paperclip.setupClasspath();
        ClassLoader parentClassLoader = Paperclip.class.getClassLoader().getParent();
        URLClassLoader classLoader = new URLClassLoader(classpathUrls, parentClassLoader);
        String mainClassName = Paperclip.findMainClass();
        System.out.println("Starting " + mainClassName);
        Thread runThread = new Thread(() -> {
            try {
                Class<?> mainClass = Class.forName(mainClassName, true, classLoader);
                MethodHandle mainHandle = MethodHandles.lookup().findStatic(mainClass, "main", MethodType.methodType(Void.TYPE, String[].class)).asFixedArity();
                mainHandle.invoke(args);
            }
            catch (Throwable t) {
                throw Util.sneakyThrow(t);
            }
        }, "ServerMain");
        runThread.setContextClassLoader(classLoader);
        runThread.start();
    }

    private static URL[] setupClasspath() {
        Path baseFile;
        Path repoDir = Path.of(System.getProperty("bundlerRepoDir", ""), new String[0]);
        PatchEntry[] patches = Paperclip.findPatches();
        DownloadContext downloadContext = Paperclip.findDownloadContext();
        if (patches.length > 0 && downloadContext == null) {
            throw new IllegalArgumentException("patches.list file found without a corresponding original-url file");
        }
        if (downloadContext != null) {
            try {
                downloadContext.download(repoDir);
            }
            catch (IOException e) {
                throw Util.fail("Failed to download original jar", e);
            }
            baseFile = downloadContext.getOutputFile(repoDir);
        } else {
            baseFile = null;
        }
        Map<String, Map<String, URL>> classpathUrls = Paperclip.extractAndApplyPatches(baseFile, patches, repoDir);
        if (Boolean.getBoolean("paperclip.patchonly")) {
            System.exit(0);
        }
        Collection<URL> versionUrls = classpathUrls.get("versions").values();
        Collection<URL> libraryUrls = classpathUrls.get("libraries").values();
        URL[] emptyArray = new URL[]{};
        URL[] urls = new URL[versionUrls.size() + libraryUrls.size()];
        System.arraycopy(versionUrls.toArray(emptyArray), 0, urls, 0, versionUrls.size());
        System.arraycopy(libraryUrls.toArray(emptyArray), 0, urls, versionUrls.size(), libraryUrls.size());
        return urls;
    }

    private static PatchEntry[] findPatches() {
        PatchEntry[] patchEntryArray;
        block9: {
            InputStream patchListStream = Paperclip.class.getResourceAsStream("/META-INF/patches.list");
            if (patchListStream == null) {
                return new PatchEntry[0];
            }
            InputStream inputStream = patchListStream;
            try {
                patchEntryArray = PatchEntry.parse(new BufferedReader(new InputStreamReader(patchListStream)));
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw Util.fail("Failed to read patches.list file", e);
                }
            }
            inputStream.close();
        }
        return patchEntryArray;
    }

    private static DownloadContext findDownloadContext() {
        String line;
        try {
            line = Util.readResourceText("/META-INF/download-context");
        }
        catch (IOException e) {
            throw Util.fail("Failed to read download-context file", e);
        }
        return DownloadContext.parseLine(line);
    }

    private static FileEntry[] findVersionEntries() {
        return Paperclip.findFileEntries("versions.list");
    }

    private static FileEntry[] findLibraryEntries() {
        return Paperclip.findFileEntries("libraries.list");
    }

    private static FileEntry[] findFileEntries(String fileName) {
        FileEntry[] fileEntryArray;
        block9: {
            InputStream libListStream = Paperclip.class.getResourceAsStream("/META-INF/" + fileName);
            if (libListStream == null) {
                return null;
            }
            InputStream inputStream = libListStream;
            try {
                fileEntryArray = FileEntry.parse(new BufferedReader(new InputStreamReader(libListStream)));
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw Util.fail("Failed to read " + fileName + " file", e);
                }
            }
            inputStream.close();
        }
        return fileEntryArray;
    }

    private static String findMainClass() {
        String mainClassName = System.getProperty("bundlerMainClass");
        if (mainClassName != null) {
            return mainClassName;
        }
        try {
            return Util.readResourceText("/META-INF/main-class");
        }
        catch (IOException e) {
            throw Util.fail("Failed to read main-class file", e);
        }
    }

    private static Map<String, Map<String, URL>> extractAndApplyPatches(Path originalJar, PatchEntry[] patches, Path repoDir) {
        if (originalJar == null && patches.length > 0) {
            throw new IllegalArgumentException("Patch data found without patch target");
        }
        Map<String, Map<String, URL>> urls = Paperclip.extractFiles(patches, originalJar, repoDir);
        Paperclip.applyPatches(urls, patches, originalJar, repoDir);
        return urls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Map<String, URL>> extractFiles(PatchEntry[] patches, Path originalJar, Path repoDir) {
        HashMap<String, Map<String, URL>> urls = new HashMap<String, Map<String, URL>>();
        try (FileSystem originalJarFs = originalJar == null ? null : FileSystems.newFileSystem(originalJar);){
            Path originalRootDir = originalJarFs == null ? null : originalJarFs.getPath("/", new String[0]);
            HashMap<String, URL> versionsMap = new HashMap<String, URL>();
            urls.putIfAbsent("versions", versionsMap);
            FileEntry[] versionEntries = Paperclip.findVersionEntries();
            Paperclip.extractEntries(versionsMap, patches, originalRootDir, repoDir, versionEntries, "versions");
            FileEntry[] libraryEntries = Paperclip.findLibraryEntries();
            HashMap<String, URL> librariesMap = new HashMap<String, URL>();
            urls.putIfAbsent("libraries", librariesMap);
            Paperclip.extractEntries(librariesMap, patches, originalRootDir, repoDir, libraryEntries, "libraries");
        }
        catch (IOException e) {
            throw Util.fail("Failed to extract jar files", e);
        }
        return urls;
    }

    private static void extractEntries(Map<String, URL> urls, PatchEntry[] patches, Path originalRootDir, Path repoDir, FileEntry[] entries, String targetName) throws IOException {
        if (entries == null) {
            return;
        }
        String targetPath = "/META-INF/" + targetName;
        Path targetDir = repoDir.resolve(targetName);
        for (FileEntry entry : entries) {
            entry.extractFile(urls, patches, targetName, originalRootDir, targetPath, targetDir);
        }
    }

    private static void applyPatches(Map<String, Map<String, URL>> urls, PatchEntry[] patches, Path originalJar, Path repoDir) {
        if (patches.length == 0) {
            return;
        }
        if (originalJar == null) {
            throw new IllegalStateException("Patches provided without patch target");
        }
        try (FileSystem originalFs = FileSystems.newFileSystem(originalJar);){
            Path originalRootDir = originalFs.getPath("/", new String[0]);
            for (PatchEntry patch : patches) {
                patch.applyPatch(urls, originalRootDir, repoDir);
            }
        }
        catch (IOException e) {
            throw Util.fail("Failed to apply patches", e);
        }
    }
}

